;incomplete changes so that help windows don't show when printing help text

;message4.lsp


(setf *print-help-mode* nil)
(defun print-help-topics ()
  (setf *print-help-mode* t)
  (set-working-directory *default-path*)
  (let* ((chap-file "chapters.txt")
         (actions-list nil)
         (topic-list (append (select (welcome-topic-list) '(1 0)) 
                             (select (topic-list) '(2 4 3 5 6 7 8 9 10))
                             (menu-item-topic-list)))
         (parts-list (list "PART I:   WELCOME" "PART II:  GETTING STARTED" 
                           "PART III: UNDERSTANDING DATA" "PART IV:  ENHANCING VISTA" 
                           "APPENDIX:   VISTA'S MENUS"))
         (part-names-list (list "WELCOME" "GETTING STARTED" 
                           "UNDERSTANDING DATA" "ENHANCING VISTA" 
                           "APPENDIX: VISTA'S MENUS"))
         (roman (list "I" "II " "III" "IV" "A"))
         (k -1)
         (subtopics-list )
         (infile-list nil)
         (title-list))
    (setf *doco-path* (strcat *default-path* "help\\help\\"))
    (setf actions-list (append (select (welcome-actions-list) '(1 0))
                               (select (actions-list) '(2 4 3 5 6 7 8 9 10))
                               (menu-item-action-list)))
    (setf subtopics-list (append (select (welcome-subtopics-list) '(1 0))
                                 (select (subtopics-list) '(2 4 3 5 6    7 8 9    10))
                                 (menu-item-subtopic-list)))
    (with-open-file
      (chap-stream chap-file :direction :output)
      (dolist (i (iseq (length actions-list)))
             (setf ii (1+ i))
             (case ii
               (1  (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (3  (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (8  (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (11 (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k)))
               (12 (setf k (1+ k))
                   (format chap-stream"~2%~A~%"(select parts-list k))))
              (format chap-stream"~%          Topic ~2,d  ~a~%" ii (string-capitalize (select topic-list i)))
              (dotimes (j (length (select actions-list i)))
                       (setf *print-help-mode* t)
                       (setf jj (1+ j))
                       (unless (or (and (= ii 1) (= jj 4))
                                   (and (= ii 3) (> jj 2)))
                               (format chap-stream "                   ~2,d.~d    ~A~%" 
                                       ii jj
                                       (string-capitalize 
                                        (select (select subtopics-list i) j)))
                               (format t "     ~2,d.~d    ~A~%" 
                                       ii jj
                                       (string-capitalize 
                                        (select (select subtopics-list i) j)))
                               (setf title 
                                     (format nil "~a - ~a - ~a (~a.~d.~d)"
                                             (select part-names-list k)
                                             (select topic-list i)
                                             (select (select subtopics-list i) j)
                                             (select roman k) ii jj))
                               (setf title-list (append title-list (list title)))
                               (setf new-help-file (format nil "~ahelp~s-~s.txt"
                                                           *doco-path* ii jj))
                               (eval (select (select actions-list i) j))
                               (send *help-window* :write-text-to-file
                                    (send *help-window* :strings) new-help-file)
                               (setf infile-list (append infile-list (list new-help-file)))
                               ))))
(break)
    (print-documentation infile-list title-list)
    (set-working-directory *default-path*)
    (system "allhelp.bat")
    (initial-help-window :show nil)
    ))


;defvar.lsp

(defmeth expert-menu-item-proto :do-action ()
;  (setf *print-help-mode* t)
;(print (list (if (send *vista* :show-help) "show help" "do menu action") "expert"
;             (if *print-help-mode* "print help" "show help")))
  (cond
    ((not (send *vista* :show-help))
     (when (and (equal $$$ @)
                (member (send self :menu)
                        (list *data-menu* *trans-menu* *spreadplot-menu* 
                              *graphics-menu* *analyze-menu*)))
           (setcd (first (send @ :dob-parents))))
     (when (author) (copyitem (send self :title)))
     (when (send self :action) (funcall (send self :action))))
    (t
     (unless (ignore-errors 
              (send *workmap* :show-help self t "title" t t (not *print-help-mode*)))
             (send *vista* :show-help nil)
             (cond 
               (*print-help-mode* 
                (send *help-window* :close)
                (send *desktop-container* :resize))
               (t
                (one-button-dialog 
                 "I'm sorry, but there is no help for this menu item."
                 :title "Help: Missing Help File"
                 :first-button "Oops ... My mistake :-(")
                (top-level nil)))))
    ))

;workmap4.lsp

(defmeth workmap-proto :show-help 
                   (icon &optional (flush t) title (add-help t) 
                         window (show (not *print-help-mode*)))
;fwy added window may 2000
;fwy added show feb 2003
"ARGS: icon &optional (flush t) title (add-help t) window (show (not *print-help-mode*))
Shows help file associated with ICON, using the icon title as the file name. Flushes existing help window unless FLUSH is nil. Displays icon title as help window title unless TITLE is not nil. Adds string \"Help: \" in front of title when add-help is T. Displays  in WINDOW"
  (let* ((icon-title (send icon :title))
         (i)
         (fit nil)
         (help-file-name)
         (w (cond 
              ((and window (not show))
               (send *vista* :help-window-object nil)
               (help-window nil :show nil))
              (window (initial-help-window))
              ((not show)  (help-window nil :show nil))
              (t (send *vista* :help-window-object))))
        )
    (setf icon-title (remove-period icon-title))
    (setf help-file-name icon-title)
    (when (equal icon-title "Menu Help") 
          (setf icon-title "Menu Help On"))
    (when (and (> (length icon-title) 4)
               (equal ":" (subseq icon-title 4 5)))
          (setf help-file-name (strcat (subseq icon-title 0 4) "-" 
                                       (subseq icon-title 5 i))))
    (setf help-file-name (blanks-to-dashes help-file-name))
    (setf i (min (list 8 (length help-file-name))))
    (setf help-file-name 
          (strcat *help-dir-name* 
                  (string-downcase 
                   (subseq help-file-name 0 i)) ".hlp"))
    (if (not title) (setf title icon-title))
    (file-to-window help-file-name title w flush add-help fit show)
    ))

;display3.lsp

;fwy added show arg feb 2003 to allow invisible 
;re-initializing after print-all-help 

(defun initial-help-window (&key (show nil))
  (let* ((w (initial-display-window 475 300 :location '(3000 3000) 
             :color 'post-it-yellow :menu nil :show show)))
    (setf *print-help-mode* nil)
    (send *vista* :set-help-variables w T)
    (setf *help-window* w)
    (when w (send w :title "Help Window"))
    (defmeth w :show-window (&key (relocate t))
      (call-next-method :relocate relocate)
      (send self :showing t)
      (when (send self :menu)
            (send (send self :menu) :remove))
      (when (< (second (send self :size)) 10)
            (send self :size 475 300)))
    (defmeth w :hide-window ()
     (call-next-method)
     (send self :showing nil))
   ; (setf *desktop-help-window* w)
   ; (when *desktop-container*
   ;       (send *desktop-container* :resize));fwy 2/2003: seems to unlock redraw
    (when show 
          (send w :top-most (send w :top-most? )))
    w))


(defun initial-display-window 
  (&optional (width 475) (height 300)  
             &key (location (list (floor (/ (- (first (effective-screen-size)) 475) 2)) 60))
             (color 'white) (show t) (menu t))
  (let* ((c (container :show nil));fwy******
         (w (cond 
              (show
               (display-window 
                " " 
                :color color
                :location location
                :size (list width height)
                :show nil :menu menu :pop-out t :fit nil))
              (t
               (display-window 
                " " 
                :color color
                :location location
                :size (list width height) :in c
                :show nil :menu menu :pop-out nil :fit nil)))))
    (send (send w :menu) :remove)
    w))


(defmeth vista-system-object-proto :set-help-variables (w state)
"Args: W STATE
Sets the help system on when STATE is T and W is a window object. Sets help system off when STATE is NIL and W is NIL. Removes current help window when STATE is NIL. In either case, sets *print-help-mode* to nil."
  (when *verbose* (PRINT "  SET-HELP-VARIABLES"))
  (cond
    ((and (not w) (not state))
     (defmeth w :remove () (call-next-method))
     (send w :remove))
    ((and (not (not w)) state)
     (defmeth w :remove ()
       (send self :bottom-most t)
       (send self :true-location (send self :location))
       (send self :location (first (send self :location)) 2000)
       ))
    (t (error "set-help-variables: both args must be either T or NIL")))
  (send *vista* :help-window-object w)
  (send *vista* :help-window-status state)
  (setf *current-help-window* w)
  (setf *current-text-window* w)
  (setf *help-window* w)
 ; (setf *print-help-mode* nil)
 ; (defmeth w :remove ()
 ;   (send self :bottom-most t)
 ;   (send self :true-location (send self :location))
 ;   (send self :location (first (send self :location)) 2000)
 ;   )
  state)

;display4.lsp

(defun help-window 
  (&optional text &key
             (location nil) (size (list 475 300)) (center nil)
             (in nil) (show t) (pop-out t) (top-most nil) (fit t) 
             (print-help-only *print-help-mode*)
             (flush t) (menu t) (color 'post-it-yellow) (title "ViSta Help"))
"Args: text &key (location (list (floor (/ (- (first (effective-screen-size)) 475) 2)) 60)) (size (list 475 300)) (title \"Help Window\") (show t) (pop-out t) (top-most nil) (fit t) (flush t) (menu t) (center nil) (color 'post-it-yellow) ) 
Creates a popped-out help display window and sets all system information to recognize it as a help window."
  (let* ((w *help-window*)
         (new-window)
         (new-location)
         (loc)
         (tloc)
         )
    ; (when w (unless (send *vista* :reuse-help-windows)(setf w nil)))
;(setf *print-help-mode* t)
;(setf print-help-only t)
;(print "HELP WINDOW")
    (when print-help-only
          (send *vista* :help-window-object nil)
          (setf show nil)
          )

;(one-button-dialog "one")
    (cond 
      (w (when flush (send w :flush-window)))
      (t (setf w  (initial-help-window))
         (setf loc (send w :location))
         (setf tloc (send w :location))
         (send w :true-location tloc)
         (setf *help-window* w)))

;(one-button-dialog "two")
;(print (list w show text fit size))
    (send w :back-color color)
    (apply #'send w :size size)
    (send w :title title)
    (send w :scroll 0 0)
    (send *vista* :set-help-variables w t)
    (when text (send w :paste-string text)
          (when fit (send w :fit-window-to-text)))
    (setf size (send w :size))

;(one-button-dialog "three")
    (setf new-location
          (cond 
            ((not (send w :true-location))
             (send w :true-location
                   (list (floor (/ (- (first (effective-screen-size)) 475) 2)) 
                         (+ (second (send *desktop-container* :location)) 50))))
            ((not (= (send w :location) (send w :true-location)))
             (send w :true-location))
            (center 
             (+ (floor (/ (- (screen-size) size) 2)) '(0 80)))
            (location 
             location)
            (t 
             (list (floor (/ (- (first (effective-screen-size)) 475) 2)) 
                   (+ (second (send *desktop-container* :location)) 50)))))
    (send w :true-location new-location)
    (when show
          (send w :bottom-most t)
          (send w :show-window)
          (send w :top-most t)
          (unless top-most (send w :top-most nil))
          (when pop-out (send w :pop-out t))
         )

    (defmeth w :close ()
      (send self :idle-on nil)
      (send self :true-location (send self :location))
      (send self :location 2000 2000))

    (defmeth w :hide-window ()
      (send self :showing nil)
      (send self :idle-on nil)
      (send self :true-location (send self :location))
      (send self :location 2000 2000))

    (defmeth w :show-window (&key (relocate nil))
      (send self :showing t)
      (if relocate
          (apply #'send self :location (send self :true-location))
          (call-next-method :relocate relocate)))

    (send w :true-location (send w :location))
    w))

;DISPLAY1.LSP

;this is overridden by definition in display3
(defun file-to-window (filename title w &optional (flush t) (add-help t))
  (send *vista* :file-to-help-window filename title w flush add-help)
  w)

;display3.lsp

(defun file-to-window 
	(filename title window &optional (flush t) (add-help t) (fit t) (show t))
"Args: filename title window &optional (flush t) (add-help t) (fit t) (show t)
Depending on value of global variable *linked-window*, constructs a help or chain window (not reports) from text in a file. All text must come from a file via this function for the help and chained windows systems to work right."
    (when *file-verbose* (format t "; reading ~a~%" filename))
  (let ((w
         (cond 
           (*linked-window* 
            (setf *linked-window* nil)
            (file-to-chain-window  filename title window flush add-help fit show))
           (t
            (file-to-single-window filename title window flush add-help fit show)))))
    (send w :add-slot 'file filename)
    (defmeth w :file (&optional (name nil set))
      (if set (setf (slot-value 'file) name))
      (slot-value 'file))
    w))


(defun file-to-single-window 
  (filename title window &optional (flush t) (add-help t) (fit t) (show t)
            (print-help-only *print-help-mode*))
"args: filename title window &optional (flush t) (add-help t) (fit t) (show t)
       (print-help-only *print-help-mode*)
gets text from filename and displays in *help-window* unless WINDOW is specified. Same args as file-to-chain-window"

;(setf *print-help-mode* t)
;(setf print-help-only t)

  (let* ((w (if window window *help-window*))
         (old-w w)
         (height))
    (when (not w)
          (setf w (initial-help-window))
          (setf old-w w))
    (setf w (send *vista* :get-window w))
    (send w :start-buffering)
    (with-open-file 
     (g filename)
     (send *vista* :set-help-variables w t) ;fwy 20010401 changed last argument in next line
     (send *vista* :update-help-window w g title flush add-help nil));from show to nil
    (send *vista* :help-window-status t)    ;to get (not relocate) to work right
    (setf *current-help-window* w)
    (setf *current-text-window* w)
    ;(send w :set-window-parameters fit show) ;fwy 20030223 added print-help-only to get
                                              ;print-help-topics to work
    (send w :set-window-parameters fit (and show (not print-help-only)))
    w))


(defmeth vista-system-object-proto :file-to-help-window
            (filename title w &optional (flush t) (add-help t) (show t))
;(message-dialog "FILE-TO-HELP-WINDOW")
  (with-open-file 
   (g filename)
   (unless w 
           (setf w (initial-help-window))
           (send *vista* :set-help-variables w T))
   (file-to-window filename title w  nil add-help)
   (send self :update-help-window w g title flush add-help show);added show
  ; (send self :update-help-window w g title flush add-help nil);added show
   (setf *current-help-window* w)
   (setf *current-text-window* w)
   t))

(defmeth vista-system-object-proto :update-help-window 
                          (w g title &optional (flush t) (add-help t) 
                             (show t) (print-help-only *print-help-mode*))
;(message-dialog (STRCAT (FORMAT NIL "ENTER UPDATE-HELP-WINDOW ~A ~A" PRINT-HELP-ONLY SHOW)))
;(setf *print-help-mode* t)
;(setf print-help-only NIL)
  (when flush (send w :flush-window))
  (send w :scroll 0 0)
  (if (or (not add-help) 
          (equal title "Bug List") 
          (equal title "About These Data"))
      (send w :title title)
      (send w :title (strcat "Help: " title)))
  (if g
      (send w :paste-stream g)
      (send w :paste-string (send *current-data* :about)))
  (if (> (send w :y) (second (send w :size))) 
       (send w :has-v-scroll (send w :y))
       (send w :has-v-scroll nil))
  (when (and show (not print-help-only))
        #+macintosh (when (not (equal (front-window) self)) (send w :show-window))
        #-macintosh (send w :show-window))

 ; (message-dialog "EXIT UPDATE-HELP-WINDOW")
  t)

;display5.lsp



(defun file-to-chain-window 
  (filename title window &optional (flush t) (add-help t) (fit t) (show t)
            (print-help-only *print-help-mode*))
"args: filename title window &optional (flush t) (add-help t) (fit t) (show t)
gets text from filename and displays in *window-chain*. Same args as file-to-window"
  (send *window-chain* :start-buffering)
  (with-open-file
   (g filename)
   (send *vista* :update-help-window *window-chain* g title flush add-help nil))
  (send *window-chain* :set-window-parameters fit (and show (not print-help-only)))
  *window-chain* )


;roughly box-diamond-and-dot to cumulative
;item-analysis